GEnvironmentFX.vehiclesAssetModel = NewCAssetModelsProbas("ItemsContent/City/Cars/",
	"Car", 5, "Car2", 5, "Bus", 2, "Bike", 3
-- "Car2", 1
)

GEnvironmentFX.vehiclesSpeedRanges = { { 0.3, 0.5 }, { 0.3, 0.5 }, { 0.2, 0.3 }, { 0.5, 0.8 } }
GEnvironmentFX.vehiclePerTile = 0.3

GEnvironmentFX.tractorAssetModel = NewCAssetModel("ItemsContent/Factories/Farm_Drone_Prefab")

local animals = {}

animals.bird = New("AnimalInfos")
animals.bird.model = NewCAssetModel("Engine/FX/Animals/Bird")
animals.bird.speedMin = 0.1
animals.bird.speedMax = 0.1
animals.bird.speedControlWalk = 3;
animals.bird.speedControlRun = 8;
animals.bird.canFly = true
animals.bird.sound = NewCAssetSound(0.5, "Sounds/SFX/SFX_Bird_Select-001", "Sounds/SFX/SFX_Bird_Select-002")
animals.bird.soundOnSelect = NewCAssetSound(1, "Sounds/SFX/SFX_Bird_Select-001", "Sounds/SFX/SFX_Bird_Select-002")
animals.bird.soundDelayMin = 30;
animals.bird.soundDelayMax = 60;

--- herbe froide : buffalo, horse
animals.buffalo = New("AnimalInfos")
animals.buffalo.model = NewCAssetModel("Engine/FX/Animals/Buffalo")
animals.buffalo.speedMin = 0.1
animals.buffalo.speedMax = 0.1
animals.buffalo.temperatureMin = -10
animals.buffalo.temperatureMax = 10
animals.buffalo.contentsToSpawnOn = { nil }
animals.buffalo.groundsToSpawnOn = { items.grass }
animals.buffalo.sound = NewCAssetSound(0.5, "Sounds/SFX/SFX_Buffalo_Select")
animals.buffalo.soundOnSelect = NewCAssetSound(1, "Sounds/SFX/SFX_Buffalo_Select")

animals.horse = New("AnimalInfos")
animals.horse.model = NewCAssetModel("Engine/FX/Animals/Horse")
animals.horse.speedMin = 0.1
animals.horse.speedMax = 0.1
animals.horse.temperatureMin = -10
animals.horse.temperatureMax = 10
animals.horse.contentsToSpawnOn = {}
animals.horse.groundsToSpawnOn = { items.grass }
animals.horse.sound = NewCAssetSound(0.5, "Sounds/SFX/SFX_Horse_Select-001", "Sounds/SFX/SFX_Horse_Select-002")
animals.horse.soundOnSelect = NewCAssetSound(1, "Sounds/SFX/SFX_Horse_Select-001", "Sounds/SFX/SFX_Horse_Select-002")

--- herbe chaude : elephant, lion, rhino
animals.elephant = New("AnimalInfos")
animals.elephant.model = NewCAssetModel("Engine/FX/Animals/Elephant")
animals.elephant.speedMin = 0.1
animals.elephant.speedMax = 0.1
animals.elephant.temperatureMin = 15
animals.elephant.temperatureMax = 40
animals.elephant.contentsToSpawnOn = {}
animals.elephant.groundsToSpawnOn = { items.grass }
animals.elephant.canDestroyBuildings = true
animals.elephant.sound = NewCAssetSound(0.5, "Sounds/SFX/SFX_Elephant_Select-001", "Sounds/SFX/SFX_Elephant_Select-002")
animals.elephant.soundOnSelect = NewCAssetSound(1, "Sounds/SFX/SFX_Elephant_Select-001", "Sounds/SFX/SFX_Elephant_Select-002")

animals.lion = New("AnimalInfos")
animals.lion.model = NewCAssetModel("Engine/FX/Animals/Lion")
animals.lion.speedMin = 0.1
animals.lion.speedMax = 0.1
animals.lion.temperatureMin = 15
animals.lion.temperatureMax = 40
animals.lion.contentsToSpawnOn = {}
animals.lion.groundsToSpawnOn = { items.grass }
animals.lion.sound = NewCAssetSound(0.5, "Sounds/SFX/SFX_Lion_Select-001", "Sounds/SFX/SFX_Lion_Select-002")
animals.lion.soundOnSelect = NewCAssetSound(1, "Sounds/SFX/SFX_Lion_Select-001", "Sounds/SFX/SFX_Lion_Select-002")

animals.rhino = New("AnimalInfos")
animals.rhino.model = NewCAssetModel("Engine/FX/Animals/Rhino")
animals.rhino.speedMin = 0.1
animals.rhino.speedMax = 0.1
animals.rhino.temperatureMin = 15
animals.rhino.temperatureMax = 40
animals.rhino.contentsToSpawnOn = {}
animals.rhino.groundsToSpawnOn = { items.grass }
animals.rhino.canDestroyBuildings = true
animals.rhino.sound = NewCAssetSound(0.5, "Sounds/SFX/SFX_Rhino_Select-001", "Sounds/SFX/SFX_Rhino_Select-002")
animals.rhino.soundOnSelect = NewCAssetSound(1, "Sounds/SFX/SFX_Rhino_Select-001", "Sounds/SFX/SFX_Rhino_Select-002")

--- pine         : bear, deer, wolf
--- euca         : boar, deer, wolf
animals.deer = New("AnimalInfos")
animals.deer.model = NewCAssetModel("Engine/FX/Animals/Deer")
animals.deer.speedMin = 0.1
animals.deer.speedMax = 0.1
animals.deer.contentsToSpawnOn = { items.forest_pine, items.forest_leavesHigh }
animals.deer.groundsToSpawnOn = { items.grass }
animals.deer.sound = NewCAssetSound(0.5, "Sounds/SFX/SFX_Deer_Select-001", "Sounds/SFX/SFX_Deer_Select-002")
animals.deer.soundOnSelect = NewCAssetSound(1, "Sounds/SFX/SFX_Deer_Select-001", "Sounds/SFX/SFX_Deer_Select-002")

animals.bear = New("AnimalInfos")
animals.bear.model = NewCAssetModel("Engine/FX/Animals/Bear")
animals.bear.speedMin = 0.1
animals.bear.speedMax = 0.1
animals.bear.contentsToSpawnOn = { items.forest_pine }
animals.bear.groundsToSpawnOn = { items.grass }
animals.bear.sound = NewCAssetSound(0.5, "Sounds/SFX/SFX_Bear_Select")
animals.bear.soundOnSelect = NewCAssetSound(1, "Sounds/SFX/SFX_Bear_Select")

animals.boar = New("AnimalInfos")
animals.boar.model = NewCAssetModel("Engine/FX/Animals/Boar")
animals.boar.speedMin = 0.1
animals.boar.speedMax = 0.1
animals.boar.contentsToSpawnOn = { items.forest_leavesHigh }
animals.boar.groundsToSpawnOn = { items.grass }
animals.boar.sound = NewCAssetSound(0.5, "Sounds/SFX/SFX_Boar_Select-001", "Sounds/SFX/SFX_Boar_Select-002")
animals.boar.soundOnSelect = NewCAssetSound(1, "Sounds/SFX/SFX_Boar_Select-001", "Sounds/SFX/SFX_Boar_Select-002")

animals.wolf = New("AnimalInfos")
animals.wolf.model = NewCAssetModel("Engine/FX/Animals/Wolf")
animals.wolf.speedMin = 0.1
animals.wolf.speedMax = 0.1
animals.wolf.contentsToSpawnOn = { items.forest_pine, items.forest_leavesHigh }
animals.wolf.groundsToSpawnOn = { items.grass }
animals.wolf.sound = NewCAssetSound(0.5, "Sounds/SFX/SFX_Wolf_Select-001", "Sounds/SFX/SFX_Wolf_Select-002")
animals.wolf.soundOnSelect = NewCAssetSound(1, "Sounds/SFX/SFX_Wolf_Select-001", "Sounds/SFX/SFX_Wolf_Select-002")

--- tropical     : gorilla
animals.gorilla = New("AnimalInfos")
animals.gorilla.model = NewCAssetModel("Engine/FX/Animals/Gorilla")
animals.gorilla.speedMin = 0.1
animals.gorilla.speedMax = 0.1
animals.gorilla.contentsToSpawnOn = { items.forest_tropical }
animals.gorilla.groundsToSpawnOn = { items.grass }
animals.gorilla.sound = NewCAssetSound(0.5, "Sounds/SFX/SFX_Gorilla_Select")
animals.gorilla.soundOnSelect = NewCAssetSound(1, "Sounds/SFX/SFX_Gorilla_Select")

--- cactus       : chameau
animals.camel = New("AnimalInfos")
animals.camel.model = NewCAssetModel("Engine/FX/Animals/Camel")
animals.camel.speedMin = 0.1
animals.camel.speedMax = 0.1
animals.camel.contentsToSpawnOn = { items.forest_cactus }
animals.camel.groundsToSpawnOn = { items.dirt }
animals.camel.sound = NewCAssetSound(0.5, "Sounds/SFX/SFX_Camel_Select-001", "Sounds/SFX/SFX_Camel_Select-002")
animals.camel.soundOnSelect = NewCAssetSound(1, "Sounds/SFX/SFX_Camel_Select-001", "Sounds/SFX/SFX_Camel_Select-002")

--- ice caps     : polar bear
animals.polarBear = New("AnimalInfos")
animals.polarBear.model = NewCAssetModel("Engine/FX/Animals/PolarBear")
animals.polarBear.speedMin = 0.1
animals.polarBear.speedMax = 0.1
animals.polarBear.temperatureMax = 5
animals.polarBear.contentsToSpawnOn = {}
animals.polarBear.groundsToSpawnOn = { items.dirt }
animals.polarBear.sound = NewCAssetSound(0.5, "Sounds/SFX/SFX_Bear_Select")
animals.polarBear.soundOnSelect = NewCAssetSound(1, "Sounds/SFX/SFX_Bear_Select")

GEnvironmentFX.animals = CreateLuaEntityList("AnimalInfos", animals, false)

GEnvironmentFX.bird = animals.bird




--- @enum
local Zoom = {
	Close = 3,
	Intermediary = 4,
	Far = 6,
	FarWithClouds = 7
}

local fxs = {}

-- fxs.dust = New("FxOnHex")
-- fxs.dust.model = NewCAssetModel("Engine/FX/DustWorld/Dust_World")
-- fxs.dust.proba = 0.00002
-- fxs.dust.isEmitting = true
-- fxs.dust.altitudeMax = 0.3
-- fxs.dust.spawnInLand = true
-- fxs.dust.windStrength = 0.5

--WIND
fxs.wind = New("FxOnHex")
fxs.wind.models = NewCAssetModelsProbas("Engine/FX/Wind/", "wind", 1, "wind_2", 1, "wind_3", 1)
fxs.wind.proba = 0.000033
fxs.wind.spawnAltitudeMin = 2
fxs.wind.spawnAltitudeMax = 4
fxs.wind.zoomMin = 2
fxs.wind.zoomMax = 3
fxs.wind.waterMax = 5
fxs.wind.spawnOnItems = { items.dirt }
fxs.wind.spawnWindFactor = 1


--LEAF
fxs.leaf = New("FxOnHex")
fxs.leaf.models = NewCAssetModelsProbas("Engine/FX/Leaf/", "leaf_LeavesHigh", 1)
fxs.leaf.proba = 0.05
fxs.leaf.isEmittingSingleParticles = true
fxs.leaf.spawnWindFactor = 0.2
fxs.leaf.spawnAltitudeMax = 0.3
fxs.leaf.spawnOnTreeWinter = false
fxs.leaf.spawnOnTreeFall = false
fxs.leaf.spawnOnTreeDead = false
fxs.leaf.spawnOnItems = { items.forest_leavesHigh }
-- fxs.leaf.zoomMax = 1

fxs.leafFall = New("FxOnHex")
fxs.leafFall.models = NewCAssetModelsProbas("Engine/FX/Leaf/", "leaf_Fall", 1)
fxs.leafFall.proba = 0.05
fxs.leafFall.isEmittingSingleParticles = true
fxs.leafFall.spawnWindFactor = 0.2
fxs.leafFall.spawnAltitudeMax = 0.3
fxs.leafFall.spawnOnTreeWinter = false
fxs.leafFall.spawnOnTreeFall = true
fxs.leafFall.spawnOnTreeDead = false
fxs.leafFall.spawnOnTreeSpringSummer = false
fxs.leafFall.spawnOnItems = { items.forest_leavesHigh }

fxs.leafPine = New("FxOnHex")
fxs.leafPine.models = NewCAssetModelsProbas("Engine/FX/Leaf/", "leaf_Pine", 1)
fxs.leafPine.proba = 0.05
fxs.leafPine.isEmittingSingleParticles = true
fxs.leafPine.spawnWindFactor = 0.2
fxs.leafPine.spawnAltitudeMax = 0.3
fxs.leafPine.spawnOnTreeDead = false
fxs.leafPine.spawnOnItems = { items.forest_pine }

fxs.leafTropical = New("FxOnHex")
fxs.leafTropical.models = NewCAssetModelsProbas("Engine/FX/Leaf/", "leaf_tropical", 1)
fxs.leafTropical.proba = 0.05
fxs.leafTropical.isEmittingSingleParticles = true
fxs.leafTropical.spawnWindFactor = 0.2
fxs.leafTropical.spawnAltitudeMax = 0.3
fxs.leafTropical.spawnOnTreeDead = false
fxs.leafTropical.spawnOnItems = { items.forest_tropical }



--DUST
fxs.dust = New("FxOnHex")
fxs.dust.models = NewCAssetModelsProbas("Engine/FX/Dust2/", "Dust2", 1)
fxs.dust.proba = 0.1
fxs.dust.isEmittingSingleParticles = true
fxs.dust.spawnWindFactor = 0
fxs.dust.spawnAltitudeMin = 0.2
fxs.dust.spawnAltitudeMax = 10
fxs.dust.spawnOnIce = true
fxs.dust.zoomMin = 0
fxs.dust.zoomMax = 2
fxs.dust.useGroundColor = true
fxs.dust.spawnOnItems = { items.dirt }

GEnvironmentFX.fxs = CreateLuaEntityList("FxOnHex", fxs)
